"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const speedDate = require("speed-date");
const core_1 = require("@kui-shell/core");
const usage_helpers_1 = require("./usage-helpers");
const dateFormatter = speedDate('MMM DD HH:mm');
const strings = core_1.i18n('plugin-bash-like');
function prettyBytes(size) {
    if (size < 1024) {
        return `${size}B`;
    }
    else if (size < 1024 * 1024) {
        return `${(size / 1024).toFixed(1)}K`;
    }
    else if (size < 1024 * 1024 * 1024) {
        return `${(size / 1024 / 1024).toFixed(1)}M`;
    }
    else if (size < 1024 * 1024 * 1024 * 1024) {
        return `${(size / 1024 / 1024 / 1024).toFixed(1)}G`;
    }
    else {
        return `${(size / 1024 / 1024 / 1024 / 1024).toFixed(1)}T`;
    }
}
function prettyTime(ms) {
    return dateFormatter(new Date(ms)).replace(/(\s)0/g, '$1 ');
}
const bySize = (rev) => (a, b) => {
    return rev * (b.stats.size - a.stats.size);
};
const byTime = (rev) => (a, b) => {
    return rev * (b.stats.mtimeMs - a.stats.mtimeMs);
};
const byLex = (rev) => (a, b) => {
    return rev * a.nameForDisplay.localeCompare(b.nameForDisplay);
};
function cssOf(glob) {
    const { isDirectory, isSymbolicLink, isExecutable, isSpecial } = glob.dirent;
    return isDirectory
        ? 'dir-listing-is-directory'
        : isSymbolicLink
            ? 'dir-listing-is-link'
            : isExecutable
                ? 'dir-listing-is-executable'
                : isSpecial
                    ? 'dir-listing-is-other-special'
                    : '';
}
function nameOf(glob) {
    return `${glob.nameForDisplay}${glob.dirent.isDirectory
        ? !glob.nameForDisplay.endsWith('/')
            ? '/'
            : ''
        : glob.dirent.isSymbolicLink
            ? '@'
            : glob.dirent.isExecutable
                ? '*'
                : ''}`;
}
const outerCSSSecondary = 'hide-with-sidecar';
const cssSecondary = 'slightly-deemphasize';
function formatPermissions({ dirent }) {
    return dirent.permissions;
}
function formatUid(entry) {
    return entry.dirent.username || entry.stats.uid.toString();
}
function formatGid(entry) {
    return entry.stats.gid.toString();
}
function attrs(entry, args) {
    const wide = args.parsedOptions.l;
    const perms = wide ? [{ value: formatPermissions(entry), outerCSS: outerCSSSecondary }] : [];
    const uid = wide ? [{ value: formatUid(entry), outerCSS: '', css: cssSecondary }] : [];
    const gid = wide ? [{ value: formatGid(entry), outerCSS: '', css: cssSecondary }] : [];
    const size = wide
        ? [{ value: prettyBytes(entry.stats.size).replace(/\s/g, ''), outerCSS: `${outerCSSSecondary} text-right` }]
        : [];
    const lastMod = wide
        ? [{ value: prettyTime(entry.stats.mtimeMs), outerCSS: 'badge-width', css: `${cssSecondary} pre-wrap` }]
        : [];
    return perms
        .concat(uid)
        .concat(gid)
        .concat(size)
        .concat(lastMod);
}
function toTable(entries, args) {
    const rev = args.parsedOptions.r ? -1 : 1;
    const sorter = args.parsedOptions.S ? bySize(rev) : args.parsedOptions.t ? byTime(rev) : byLex(rev);
    const body = entries.sort(sorter).map(_ => ({
        name: nameOf(_),
        css: cssOf(_),
        onclickExec: 'pexec',
        onclick: `${_.dirent.isDirectory ? 'ls' : 'open'} ${args.REPL.encodeComponent(_.path)}`,
        attributes: attrs(_, args)
    }));
    if (!args.parsedOptions.l) {
        const frag = document.createDocumentFragment();
        body.forEach(_ => {
            const cell = document.createElement('div');
            cell.innerText = _.name;
            if (_.css) {
                cell.classList.add(_.css);
            }
            cell.classList.add('clickable');
            cell.onclick = () => args.REPL.pexec(_.onclick);
            frag.appendChild(cell);
        });
        const container = document.createElement('div');
        container.classList.add('grid-layout');
        container.appendChild(frag);
        return container;
    }
    else {
        const wide = args.parsedOptions.l;
        const perms = wide ? [{ value: 'PERMISSIONS', outerCSS: outerCSSSecondary }] : [];
        const uid = wide ? [{ value: 'USER', outerCSS: '' }] : [];
        const gid = wide ? [{ value: 'GROUP', outerCSS: '' }] : [];
        const size = wide ? [{ value: 'SIZE', outerCSS: `${outerCSSSecondary} text-right` }] : [];
        const lastMod = wide ? [{ value: 'LAST MODIFIED', outerCSS: 'badge-width' }] : [];
        const header = {
            name: 'NAME',
            attributes: perms
                .concat(uid)
                .concat(gid)
                .concat(size)
                .concat(lastMod)
        };
        return {
            header,
            body,
            noSort: true,
            noEntityColors: true,
            style: core_1.TableStyle.Light
        };
    }
}
const doLs = (cmd) => (opts) => __awaiter(void 0, void 0, void 0, function* () {
    const semi = yield opts.REPL.semicolonInvoke(opts);
    if (semi) {
        return semi;
    }
    else if (/\|/.test(opts.command)) {
        return opts.REPL.qexec(`sendtopty ${opts.command}`, opts.block);
    }
    if (cmd === 'lls') {
        opts.parsedOptions.l = true;
    }
    const entries = (yield opts.REPL.rexec(`kuiglob ${opts.argvNoOptions
        .slice(opts.argvNoOptions.indexOf(cmd) + 1)
        .map(_ => opts.REPL.encodeComponent(_))
        .join(' ')} ${opts.parsedOptions.l ? '-l' : ''} ${opts.parsedOptions.C ? '-C' : ''} ${opts.parsedOptions.a || opts.parsedOptions.all || opts.parsedOptions.A ? '-a' : ''} ${opts.parsedOptions.d ? '-d' : ''}`)).content;
    return toTable(entries, opts);
});
const usage = (command) => ({
    command,
    title: strings('lsUsageTitle'),
    header: strings('lsUsageHeader'),
    noHelpAlias: true,
    optional: usage_helpers_1.localFilepath.concat([
        { name: '-A', boolean: true, docs: strings('lsDashAUsageDocs') },
        {
            name: '-a',
            boolean: true,
            docs: strings('lsDashaUsageDocs')
        },
        { name: '-d', boolean: true, docs: strings('lsDashdUsageDocs') },
        {
            name: '-c',
            boolean: true,
            docs: strings('lsDashcUsageDocs')
        },
        { name: '-C', boolean: true, hidden: true },
        { name: '-l', boolean: true, hidden: true },
        { name: '-h', boolean: true, hidden: true },
        {
            name: '-t',
            boolean: true,
            docs: strings('lsDashtUsageDocs')
        },
        { name: '-r', boolean: true, docs: strings('lsDashrUsageDocs') },
        { name: '-s', boolean: true, hidden: true },
        { name: '-S', boolean: true, docs: strings('lsDashSUsageDocs') }
    ])
});
exports.default = (commandTree) => {
    const ls = commandTree.listen('/ls', doLs('ls'), {
        usage: usage('ls'),
        requiresLocal: true,
        inBrowserOk: true,
        flags: {
            boolean: usage('ls')
                .optional.filter(_ => _.boolean)
                .map(_ => _.name.replace(/^-(-)?/, ''))
        }
    });
    commandTree.synonym('/lls', doLs('lls'), ls, {
        usage: usage('lls'),
        requiresLocal: true,
        inBrowserOk: true
    });
};
//# sourceMappingURL=ls.js.map