"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const path_1 = require("path");
const core_1 = require("@kui-shell/core");
const markdown_1 = require("./markdown");
const usage_helpers_1 = require("./usage-helpers");
const strings = core_1.i18n('plugin-bash-like');
const debug = debug_1.default('plugins/bash-like/cmds/open');
function open({ tab, argvNoOptions, REPL }) {
    return __awaiter(this, void 0, void 0, function* () {
        const filepath = argvNoOptions[argvNoOptions.indexOf('open') + 1];
        debug('open', filepath);
        const fullpath = core_1.findFile(core_1.expandHomeDir(filepath));
        const suffix = filepath.substring(filepath.lastIndexOf('.') + 1);
        if (suffix === 'js' ||
            suffix === 'ts' ||
            suffix === 'go' ||
            suffix === 'txt' ||
            suffix === 'swift' ||
            suffix === 'py' ||
            suffix === 'json' ||
            suffix === 'yaml') {
            return REPL.qexec(`edit "${filepath}"`);
        }
        else if (suffix === 'png' ||
            suffix === 'jpg' ||
            suffix === 'jpeg' ||
            suffix === 'tiff' ||
            suffix === 'tif' ||
            suffix === 'gif' ||
            suffix === 'icns' ||
            suffix === 'ico' ||
            suffix === 'webp' ||
            suffix === 'bpg' ||
            suffix === 'svg' ||
            suffix === 'mov' ||
            suffix === 'mp4' ||
            suffix === 'ogg' ||
            suffix === 'mp3') {
            window.open(fullpath, 'target=_blank');
            return true;
        }
        else if (suffix === 'pkl' || suffix === 'sab') {
            throw new Error('Opening of binary files not supported');
        }
        else {
            const stats = (yield REPL.rexec(`fstat ${REPL.encodeComponent(filepath)} --with-data`)).content;
            if (stats.isDirectory) {
                debug('trying to open a directory; delegating to ls');
                return REPL.qexec(`ls ${REPL.encodeComponent(filepath)}`);
            }
            else {
                const enclosingDirectory = path_1.dirname(filepath);
                let data = stats.data;
                let name = path_1.basename(filepath);
                let packageName = enclosingDirectory === '.' ? undefined : enclosingDirectory;
                if ((suffix === 'adoc' || suffix === 'md') && !core_1.isHeadless()) {
                    const { title, body } = yield markdown_1.default(tab, suffix, data, fullpath);
                    data = body;
                    if (title) {
                        packageName = name;
                        name = title.innerText;
                    }
                }
                return {
                    type: 'custom',
                    kind: 'file',
                    metadata: {
                        name,
                        namespace: packageName
                    },
                    contentType: suffix === 'sh' ? 'shell' : suffix,
                    content: data
                };
            }
        }
    });
}
const usage = {
    strict: 'open',
    command: 'open',
    title: strings('openUsageTitle'),
    header: strings('openUsageHeader'),
    optional: usage_helpers_1.localFilepath
};
exports.default = (registrar) => {
    registrar.listen('/open', open, { usage, needsUI: true, inBrowserOk: true });
};
//# sourceMappingURL=open.js.map