"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const marked = require("marked");
const core_1 = require("@kui-shell/core");
const version_json_1 = require("@kui-shell/client/config.d/version.json");
const name_json_1 = require("@kui-shell/client/config.d/name.json");
const usage_1 = require("./usage");
const clientStrings = core_1.i18n('client', 'about');
const debug = debug_1.default('plugins/core-support/about');
function markdown() {
    return __awaiter(this, void 0, void 0, function* () {
        const renderer = new marked.Renderer();
        renderer.link = (href, title, text) => {
            return `<a href="${href}" title="${title}" target="_blank" class="bx--link">${text}</a>`;
        };
        return (raw) => marked(raw, { renderer });
    });
}
function renderVersion(name) {
    const bottomContent = document.createElement('div');
    bottomContent.classList.add('about-window-bottom-content');
    const table = document.createElement('table');
    table.classList.add('bx--data-table');
    table.classList.add('result-table');
    table.classList.add('versions');
    table.setAttribute('kui-table-style', 'Medium');
    bottomContent.appendChild(table);
    const versionModel = process.versions;
    versionModel[name] = version_json_1.version;
    const thead = document.createElement('thead');
    thead.classList.add('entity');
    table.appendChild(thead);
    const headerRow = document.createElement('tr');
    thead.appendChild(headerRow);
    headerRow.className = 'header-row entity-attributes';
    const column1 = document.createElement('th');
    const column1Text = document.createElement('span');
    column1Text.classList.add('cell-inner');
    column1Text.classList.add('bx--table-header-label');
    column1.appendChild(column1Text);
    headerRow.appendChild(column1);
    column1Text.innerText = 'component';
    column1.className = 'header-cell';
    const column2 = document.createElement('th');
    const column2Text = document.createElement('span');
    column2Text.classList.add('cell-inner');
    column2Text.classList.add('bx--table-header-label');
    column2.appendChild(column2Text);
    headerRow.appendChild(column2);
    column2Text.innerText = 'version';
    column2.className = 'header-cell';
    const tbody = document.createElement('tbody');
    tbody.classList.add('entity');
    table.appendChild(tbody);
    for (const component of [name, 'build', 'electron', 'chrome', 'node', 'v8']) {
        const version = versionModel[component];
        if (version !== undefined) {
            const row = document.createElement('tr');
            row.classList.add('entity-attributes');
            tbody.appendChild(row);
            const nameCell = row.insertCell(-1);
            const nameCellText = document.createElement('span');
            nameCell.appendChild(nameCellText);
            nameCellText.classList.add('cell-inner');
            nameCellText.innerText = component;
            const versionCell = row.insertCell(-1);
            const versionCellText = document.createElement('span');
            versionCell.appendChild(versionCellText);
            versionCellText.classList.add('cell-inner');
            versionCellText.innerText = versionModel[component];
            row.appendChild(versionCell);
            if (component === name) {
                nameCell.classList.add('semi-bold');
                nameCell.classList.add('cyan-text');
                versionCell.classList.add('semi-bold');
                versionCell.classList.add('cyan-text');
            }
            else {
                nameCell.classList.add('lighter-text');
            }
        }
    }
    return bottomContent;
}
function renderTutorial(args) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            return args.REPL.qexec('tutorial play @tutorials/getting-started');
        }
        catch (err) {
            console.error(err);
            const empty = document.createElement('div');
            return empty;
        }
    });
}
function renderContentFromCommand(command, args) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const response = yield args.REPL.qexec(command, undefined, undefined, { render: true });
            debug('rendering content', command, response);
            const container = document.createElement('div');
            const innerContainer = document.createElement('div');
            container.classList.add('about-window-bottom-content');
            innerContainer.style.display = 'flex';
            innerContainer.style.flex = '1';
            response.style.flex = '1';
            container.appendChild(innerContainer);
            innerContainer.appendChild(response);
            return container;
        }
        catch (err) {
            console.error(err);
            const empty = document.createElement('div');
            return empty;
        }
    });
}
function renderMarkdownContent(content) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const marked = yield markdown();
            const wrapper = document.createElement('div');
            wrapper.classList.add('page-content');
            wrapper.innerHTML = marked(content);
            return wrapper;
        }
        catch (err) {
            console.error(err);
            const empty = document.createElement('div');
            return empty;
        }
    });
}
function findCommand(mode, args) {
    return (args && args.parsedOptions.contentFrom) || mode.contentFrom;
}
function findContent(mode, args) {
    return (args && args.parsedOptions.content) || mode.content;
}
const aboutWindow = (args) => __awaiter(void 0, void 0, void 0, function* () {
    debug('aboutWindow');
    core_1.injectCSS({
        css: require('@kui-shell/plugin-core-support/web/css/about.css'),
        key: 'about-window-css'
    });
    const name = name_json_1.productName ||
        (!core_1.inBrowser() &&
            (yield Promise.resolve().then(() => require('./electron-helpers'))).getAppName());
    const contentDom = document.createElement('div');
    contentDom.classList.add('about-window');
    const modesFromAbout = yield Promise.resolve().then(() => require('@kui-shell/client/config.d/about.json')).then(_ => _.modes);
    const modeCurrent = modesFromAbout.find(_ => _.mode === args.parsedOptions.mode) ||
        modesFromAbout.find(_ => _.defaultMode) ||
        modesFromAbout[0];
    const command = findCommand(modeCurrent, args);
    const content = clientStrings(findContent(modeCurrent, args));
    if (command) {
        if (command === 'about --mode version') {
            contentDom.appendChild(renderVersion(name));
        }
        else if (command === 'about --mode tutorial') {
            contentDom.appendChild(yield renderTutorial(args));
        }
        else {
            contentDom.appendChild(yield renderContentFromCommand(command, args));
        }
    }
    else {
        contentDom.appendChild(yield renderMarkdownContent(content));
    }
    const modes = modesFromAbout.map((modeFromAbout) => {
        const mode = modeFromAbout.mode;
        const content = findContent(modeFromAbout);
        const contentFrom = findCommand(modeFromAbout);
        const label = clientStrings(modeFromAbout.label || modeFromAbout.mode);
        return {
            mode,
            label,
            contentFrom: contentFrom
                ? `about --mode ${mode} --contentFrom "${contentFrom}"`
                : `about --mode ${mode} --content "${content}"`
        };
    });
    modes.find(_ => _.mode === modeCurrent.mode).defaultMode = true;
    return {
        type: 'custom',
        prettyType: 'about',
        presentation: (document.body.classList.contains('subwindow') && core_1.Presentation.SidecarFullscreen) || core_1.Presentation.SidecarThin,
        modes,
        metadata: {
            name
        },
        content: contentDom
    };
});
const getVersion = () => {
    debug('getVersion');
    return version_json_1.version;
};
const reportVersion = () => {
    debug('reportVersion');
    const version = getVersion();
    return version;
};
exports.default = (commandTree) => {
    debug('init');
    if (!commandTree) {
        return aboutWindow({});
    }
    commandTree.listen('/version', reportVersion, { usage: usage_1.default.version });
    commandTree.listen('/about', aboutWindow, {
        hidden: true,
        needsUI: true,
        inBrowserOk: true
    });
    commandTree.listen('/getting/started', ({ REPL }) => REPL.qexec('about --mode tutorial'), {
        needsUI: true,
        inBrowserOk: true
    });
};
//# sourceMappingURL=about.js.map