"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('plugins/core-support/help');
debug('loading');
const core_1 = require("@kui-shell/core");
const strings = core_1.i18n('plugin-core-support');
const help = usage => ({ argvNoOptions: args, REPL }) => {
    const rest = args.slice(args.indexOf('help') + 1);
    debug('help command', rest);
    if (rest.length > 0) {
        debug('reversal');
        return REPL.qexec(rest
            .concat('help')
            .map(val => REPL.encodeComponent(val))
            .join(' '));
    }
    else if (usage) {
        debug('usage-based', args);
        const topLevelUsage = {
            title: strings('helpUsageTitle'),
            header: 'A summary of the top-level command structure.',
            available: [],
            nRowsInViewport: 8
        };
        for (const key in usage) {
            const { route, usage: model } = usage[key];
            if (model &&
                !model.synonymFor &&
                (core_1.isHeadless() || !model.headlessOnly) &&
                (!core_1.inBrowser() || !model.requiresLocal)) {
                topLevelUsage.available.push({
                    label: route.substring(1),
                    available: model.available,
                    hidden: model.hidden,
                    synonyms: model.synonyms,
                    command: model.commandPrefix || model.command,
                    docs: model.command ? model.header : model.title
                });
            }
        }
        debug('generated top-level usage model');
        throw new core_1.UsageError({ usage: topLevelUsage });
    }
    else {
        debug('no usage model');
        const error = new Error('No documentation found');
        error.code = 404;
        throw error;
    }
};
exports.default = (commandTree, { usage }) => __awaiter(void 0, void 0, void 0, function* () {
    commandTree.listen('/help', help(usage), {
        noAuthOk: true,
        inBrowserOk: true
    });
    commandTree.listen('/?', help(usage), {
        noAuthOk: true,
        inBrowserOk: true
    });
});
//# sourceMappingURL=help.js.map