"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const core_1 = require("@kui-shell/core");
const debug = debug_1.default('plugins/core-support/history');
const DEFAULT_HISTORY_N = 20;
const parseN = str => {
    try {
        return parseInt(str, 10);
    }
    catch (e) {
    }
};
const usage = {
    history: {
        command: 'history',
        strict: 'history',
        docs: 'List current command history, optionally filtering by a given string',
        example: 'history 100 filterString',
        optional: [
            { name: 'N', positional: true, docs: 'list the most recent N commands' },
            {
                name: 'filterString',
                positional: true,
                docs: 'filter command history'
            },
            { name: '--clear', alias: '-c', docs: 'clear your command history' }
        ]
    },
    again: (command) => ({
        command,
        strict: command,
        docs: 'Re-execute a given command index',
        example: `${command} 50`,
        optional: [
            {
                name: 'N',
                positional: true,
                docs: 're-execute the given history index N'
            }
        ]
    })
};
const again = ({ tab, REPL }, N, historyEntry) => __awaiter(void 0, void 0, void 0, function* () {
    debug('again', N, historyEntry);
    const history = yield core_1.History(tab);
    if (!history.line(N)) {
        throw new Error('Could not find the command to re-execute');
    }
    else {
        history.update(historyEntry, entry => {
            entry.raw = history.line(N).raw;
        });
        return REPL.qexec(history.line(N).raw);
    }
});
const showHistory = ({ tab, argv, parsedOptions: options }) => __awaiter(void 0, void 0, void 0, function* () {
    const history = yield core_1.History(tab);
    if (options.c) {
        debug('clearing command history');
        return history.wipe();
    }
    const historyIdx = argv.indexOf('history');
    const Nargs = argv.length - historyIdx - 1;
    const firstArgLooksLikeN = parseN(argv[historyIdx + 1]);
    const Nidx = Nargs === 2 || firstArgLooksLikeN ? historyIdx + 1 : -1;
    const N = Nidx > 0 ? firstArgLooksLikeN : DEFAULT_HISTORY_N;
    const filterIdx = Nargs === 2 ? historyIdx + 2 : !firstArgLooksLikeN ? historyIdx + 1 : -1;
    const filterStr = filterIdx > 0 && argv[filterIdx];
    const filter = filterStr ? line => line.raw.indexOf(filterStr) >= 0 : () => true;
    const startIdx = Math.max(0, history.cursor - N - 1);
    const endIdx = history.cursor - 1;
    const recent = history.slice(startIdx, endIdx);
    debug('argv', argv);
    debug('Nargs', Nargs);
    debug('Nidx', Nidx);
    debug('N', N);
    debug('filterIdx', filterIdx);
    debug('filterStr', filterStr);
    debug('got', recent.length, startIdx, endIdx);
    const body = recent
        .map((line, idx) => {
        if (!filter(line))
            return;
        const shortForm = line.raw.substring(0, line.raw.indexOf(' =')) || line.raw;
        const whitespace = shortForm.indexOf(' ');
        const command = document.createElement('strong');
        const rest = document.createElement('span');
        command.innerText = shortForm.substring(0, whitespace === -1 ? shortForm.length : whitespace);
        if (whitespace !== -1) {
            rest.innerText = shortForm.substring(whitespace);
        }
        return new core_1.Row({
            beforeAttributes: [
                {
                    key: 'N',
                    value: `${startIdx + idx}`,
                    css: 'deemphasize'
                }
            ],
            fullName: line.raw,
            name: line.raw,
            type: 'history',
            onclick: line.raw
        });
    })
        .filter(x => x);
    return new core_1.Table({
        noSort: true,
        body
    });
});
exports.default = (commandTree) => {
    debug('init');
    commandTree.listen('/history', showHistory, {
        usage: usage.history,
        inBrowserOk: true,
        noAuthOk: true
    });
    const againCmd = () => (args) => __awaiter(void 0, void 0, void 0, function* () {
        const history = yield core_1.History(args.tab);
        const N = args.argv[1] ? parseInt(args.argv[1], 10) : history.cursor - 2;
        debug('againCmd', args.execOptions);
        return again(args, N, args.execOptions && args.execOptions.history);
    });
    const cmd = commandTree.listen('/!!', againCmd(), {
        usage: usage.again('!!'),
        inBrowserOk: true,
        noAuthOk: true
    });
    commandTree.synonym('/again', againCmd(), cmd, {
        usage: usage.again('again'),
        inBrowserOk: true,
        noAuthOk: true
    });
};
//# sourceMappingURL=history.js.map