"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const core_1 = require("@kui-shell/core");
const debug = debug_1.default('plugins/core-support/prompt');
const usage = {
    command: 'prompt',
    strict: 'prompt',
    hidden: true,
    optional: [{ name: 'promptString', positional: true, docs: 'The prompt string' }]
};
exports.default = (commandTree) => {
    commandTree.listen('/prompt', ({ argvNoOptions, block, nextBlock, tab }) => {
        const placeholder = argvNoOptions[1] || 'Test prompt';
        debug('placeholder', placeholder, argvNoOptions);
        return core_1.prompt('Prompt', block, nextBlock, tab, {
            placeholder
        }, options => {
            debug('response', options.field);
            return Promise.resolve(options.field);
        });
    }, { usage, noAuthOk: true, inBrowserOk: true });
};
//# sourceMappingURL=prompt.js.map