"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const doQuit = ({ REPL }) => REPL.qexec('tab close');
const usage = (command) => ({
    command,
    strict: command,
    docs: 'Quit the program'
});
exports.default = (commandTree) => {
    const quitCmd = commandTree.listen('/quit', doQuit, {
        usage: usage('quit'),
        inBrowserOk: true
    });
    commandTree.synonym('/exit', doQuit, quitCmd, {
        usage: usage('exit'),
        inBrowserOk: true
    });
};
//# sourceMappingURL=quit.js.map