"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
function addVisibilityStatusToDocument() {
    document.body.classList.add('search-bar-is-visible');
}
function removeVisibilityStatusFromDocument() {
    document.body.classList.remove('search-bar-is-visible');
}
function injectContent() {
    return __awaiter(this, void 0, void 0, function* () {
        const { injectCSS } = yield Promise.resolve().then(() => require('@kui-shell/core'));
        injectCSS({
            css: require('@kui-shell/plugin-core-support/web/css/text-search.css'),
            key: 'plugin-core-support.kui-shell.org/text-search.css'
        });
        const searchBar = document.createElement('div');
        searchBar.setAttribute('id', 'search-bar');
        searchBar.style.opacity = '0';
        searchBar.innerHTML = `<div id='search-container'><div id='search-input-container'><input id='search-input' type='text' aria-label='Search' placeholder='search term'/><span id='search-found-text' class='no-search-yet'></span></div><span id='search-close-button'><svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" aria-hidden="true"><path d="M12 4.7l-.7-.7L8 7.3 4.7 4l-.7.7L7.3 8 4 11.3l.7.7L8 8.7l3.3 3.3.7-.7L8.7 8z"></path></svg></span></div>`;
        const input = searchBar.querySelector('#search-input');
        input.onfocus = () => input.select();
        input.onclick = (evt) => {
            evt.stopPropagation();
            return false;
        };
        const page = document.querySelector('body > .page');
        page.insertBefore(searchBar, page.querySelector('main').nextSibling);
        const searchInput = searchBar.querySelector('#search-input');
        const searchFoundText = searchBar.querySelector('#search-found-text');
        const { remote } = yield Promise.resolve().then(() => require('electron'));
        const stopSearch = (clear) => {
            remote.getCurrentWebContents().stopFindInPage('clearSelection');
            if (clear) {
                setTimeout(() => __awaiter(this, void 0, void 0, function* () {
                    const { getCurrentPrompt } = yield Promise.resolve().then(() => require('@kui-shell/core'));
                    getCurrentPrompt().focus();
                }), 300);
            }
        };
        const closeSearchBox = () => {
            searchBar.classList.remove('visible');
            removeVisibilityStatusFromDocument();
            searchFoundText.innerHTML = '';
            stopSearch(true);
        };
        const searchCloseButton = searchBar.querySelector('#search-close-button');
        searchCloseButton.onclick = closeSearchBox;
        const searchText = (value) => {
            searchFoundText.classList.remove('no-search-yet');
            remote.getCurrentWebContents().findInPage(value);
        };
        remote.getCurrentWebContents().on('found-in-page', (event, result) => {
            if (!result.finalUpdate) {
                return;
            }
            const v = searchInput.value;
            searchInput.value = '';
            searchInput.value = v;
            searchInput.focus();
            if (result.matches === 1) {
                searchFoundText.innerText = 'no matches';
            }
            else if (result.matches === 2) {
                searchFoundText.innerText = '1 match';
            }
            else {
                searchFoundText.innerText = result.matches - 1 + ' matches';
            }
        });
        searchInput.onpaste = (evt) => {
            evt.stopPropagation();
        };
        searchInput.addEventListener('click', () => {
            searchInput.focus();
        });
        searchInput.addEventListener('keyup', (e) => {
            if (e.key === 'Enter') {
                if (searchInput.value.length > 0) {
                    searchText(searchInput.value);
                }
                else {
                    searchFoundText.innerHTML = '';
                    stopSearch(true);
                }
            }
            else if (e.key === 'Escape') {
                e.stopPropagation();
                closeSearchBox();
            }
        });
        window.onbeforeunload = () => {
            stopSearch(false);
            remote.getCurrentWebContents().removeAllListeners('found-in-page');
        };
        return searchBar;
    });
}
function getSearchBar(createIfAbsent = false) {
    return __awaiter(this, void 0, void 0, function* () {
        let searchBar = document.querySelector('#search-bar');
        if (!searchBar && createIfAbsent) {
            searchBar = yield injectContent();
        }
        if (searchBar) {
            const searchInput = searchBar.querySelector('#search-input');
            const searchFoundText = searchBar.querySelector('#search-found-text');
            return { searchBar, searchInput, searchFoundText };
        }
    });
}
function registerListener() {
    return __awaiter(this, void 0, void 0, function* () {
        const { KeyCodes } = yield Promise.resolve().then(() => require('@kui-shell/core'));
        document.body.addEventListener('keydown', function (e) {
            return __awaiter(this, void 0, void 0, function* () {
                if (!e.defaultPrevented &&
                    e.keyCode === KeyCodes.F &&
                    ((e.ctrlKey && process.platform !== 'darwin') || e.metaKey)) {
                    const barBits = yield getSearchBar(true);
                    if (!barBits) {
                        console.error('unable to initialize search DOM');
                        return;
                    }
                    const { searchBar, searchFoundText, searchInput } = barBits;
                    searchBar.classList.add('visible');
                    addVisibilityStatusToDocument();
                    searchBar.style.opacity = '';
                    searchFoundText.innerText = 'hit enter to search';
                    searchFoundText.classList.add('no-search-yet');
                    searchInput.focus();
                }
            });
        });
    });
}
exports.default = () => {
    if (core_1.inElectron() && typeof document !== 'undefined') {
        registerListener();
    }
};
//# sourceMappingURL=text-search.js.map