"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('plugins/core-support/preload');
debug('loading');
const core_1 = require("@kui-shell/core");
const registration = (commandTree) => __awaiter(void 0, void 0, void 0, function* () {
    const asyncs = [];
    if (!core_1.isHeadless()) {
        asyncs.push(Promise.resolve().then(() => require('./lib/cmds/zoom')).then(_ => _.preload()));
        asyncs.push(Promise.resolve().then(() => require('./lib/new-tab')).then(_ => _.default(commandTree)));
        asyncs.push(Promise.resolve().then(() => require('./lib/cmds/history/reverse-i-search')).then(_ => _.default()));
    }
    if (!core_1.isHeadless() && !core_1.inBrowser()) {
        asyncs.push(Promise.resolve().then(() => require('./lib/text-search')).then(_ => _.default()));
    }
    return Promise.all(asyncs);
});
exports.default = registration;
debug('finished loading');
//# sourceMappingURL=preload.js.map