"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('plugins/editor/file-types');
exports.language = kind => {
    const base = kind.substring(0, kind.indexOf(':')) || kind;
    debug('language', kind, base);
    if (base === 'nodejs' || base === 'app' || base === 'composition' || base === 'sequence') {
        return 'javascript';
    }
    else if (base === 'ts') {
        return 'typescript';
    }
    else if (base === 'md') {
        return 'markdown';
    }
    else if (base === 'sh') {
        return 'shell';
    }
    else if (base === 'yml') {
        return 'yaml';
    }
    else {
        return base;
    }
};
exports.extension = kind => {
    const lang = exports.language(kind);
    debug('extension', kind, lang);
    switch (lang) {
        case 'javascript':
            return '.js';
        case 'typescript':
            return '.js';
        case 'python':
            return '.py';
        default:
            return `.${lang}`;
    }
};
//# sourceMappingURL=file-types.js.map