"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = (options) => ({
    automaticLayout: true,
    minimap: {
        enabled: false
    },
    cursorWidth: 3,
    autoIndent: true,
    codeLens: false,
    quickSuggestions: false,
    contextmenu: false,
    scrollBeyondLastLine: false,
    scrollBeyondLastColumn: 2,
    fontFamily: 'var(--font-monospace)',
    fontSize: parseInt(getComputedStyle(document.querySelector('.repl-inner'))
        .getPropertyValue('font-size')
        .replace(/px$/, ''), 10) * (document.body.classList.contains('subwindow') ? 1 : 0.875),
    glyphMargin: !options.readOnly,
    lineNumbers: !options.simple,
    renderIndentGuides: !options.simple,
    renderLineHighlight: options.simple ? 'none' : 'all',
    value: '',
    language: 'javascript'
});
//# sourceMappingURL=defaults.js.map