"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const persisters_1 = require("./persisters");
const strings = core_1.i18n('plugin-editor');
exports.respondToRepl = (extraModes = []) => (response) => {
    const entity = response.getEntity();
    const buttons = [persisters_1.save(response), persisters_1.revert(response)].concat(extraModes.map(modeFn => modeFn(response)));
    const resp = {
        kind: entity.kind,
        version: entity.version,
        metadata: {
            name: (entity.metadata && entity.metadata.name) || entity.name,
            generation: entity.version || (entity.metadata && entity.metadata.generation),
            namespace: entity.namespace || (entity.metadata && entity.metadata.namespace)
        },
        content: response.content,
        toolbarText: response.toolbarText,
        modes: [
            {
                mode: 'edit',
                label: strings('Edit'),
                content: response.content
            }
        ],
        buttons
    };
    return resp;
};
exports.default = exports.respondToRepl;
//# sourceMappingURL=util.js.map