import { Button } from '@kui-shell/core';
import EditorEntity from './entity';
import { EditorResource, EditorState, Editor } from './response';
export interface Persister {
    getCode: (entity: EditorEntity) => EditorEntity;
    saveString: string;
    save: (entity: EditorEntity, editor: Editor, state: EditorState) => Promise<EditorEntity>;
    revert: (entity: EditorEntity, state: EditorState) => Promise<EditorEntity>;
}
/**
 * Logic for saving and reverting
 *
 */
export declare const persisters: {
    files: Persister;
};
/**
 * Save the given entity
 *
 */
export declare const save: (state: EditorState) => Button<EditorResource>;
/**
 * Revert to the currently deployed version
 *
 */
export declare const revert: (state: EditorState) => Button<EditorResource>;
