/*
 * Copyright 2018 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import Debug from 'debug';
const debug = Debug('plugins/editor/readonly');
/**
 * Enter read-only mode
 *
 */
export const gotoReadonlyLocalFile = ({ getEntity }) => (tab) => __awaiter(void 0, void 0, void 0, function* () {
    const entity = yield getEntity(tab);
    debug('readonly', entity.name, entity);
    return tab.REPL.pexec(`open ${tab.REPL.encodeComponent(entity.filepath)}`);
});
/**
 * Enter edit mode
 *
 */
export const edit = ({ getEntity, lock = undefined }) => (tab) => __awaiter(void 0, void 0, void 0, function* () {
    const { namespace, name } = yield getEntity(tab);
    return tab.REPL.qexec(`edit "/${namespace}/${name}"`, undefined, undefined, {
        custom: { getEntity, lock }
    });
});
/**
 * Render a lock/unlock icon as a mode button
 *
 */
export const lockIcon = ({ getEntity, mode = 'lock', // doesn't need to be translated, as we use an icon
label = 'Done Editing', 
// icon = 'fas fa-unlock-alt',
tooltip = 'Return to read-only mode', // TODO externalize string
command = gotoReadonlyLocalFile({ getEntity }) }) => ({
    mode,
    label,
    flush: 'weak',
    actAsButton: true,
    // fontawesome: icon,
    balloon: tooltip,
    command,
    kind: 'drilldown'
});
//# sourceMappingURL=readonly.js.map