"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const plugin_kubeui_1 = require("@kui-shell/plugin-kubeui");
const exec_1 = require("./exec");
const help_1 = require("./help");
const command_prefix_1 = require("../command-prefix");
function doHistory(args) {
    return __awaiter(this, void 0, void 0, function* () {
        const response = yield exec_1.default(args);
        if (help_1.isUsage(args)) {
            help_1.doHelp(response);
        }
        const preTables = plugin_kubeui_1.preprocessTable(response.split(/^(?=LAST SEEN|NAMESPACE|NAME\s+)/m));
        return plugin_kubeui_1.formatTable('helm', undefined, undefined, args.parsedOptions, preTables[0]);
    });
}
exports.default = (registrar) => {
    registrar.listen(`/${command_prefix_1.default}/helm/history`, doHistory, {
        inBrowserOk: true
    });
};
//# sourceMappingURL=history.js.map