"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const release_1 = require("../models/release");
const strings = core_1.i18n('plugin-helmui');
exports.default = {
    when: release_1.isHelmRelease,
    mode: {
        mode: 'values',
        label: strings('Values'),
        content: (_, resource) => {
            return {
                contentFrom: `helm get values ${resource.metadata.name}`,
                contentType: 'json'
            };
        }
    }
};
//# sourceMappingURL=values.js.map