"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_1 = require("@kui-shell/test");
const synonyms = ['helm'];
describe(`helm repo add and search ${process.env.MOCHA_RUN_TARGET}`, function () {
    before(test_1.Common.before(this));
    after(test_1.Common.after(this));
    synonyms.forEach(helm => {
        const addRepo = () => {
            it('should add a helm repo', () => {
                return test_1.CLI.command(`${helm} repo add bitnami https://charts.bitnami.com/bitnami`, this.app)
                    .then(test_1.ReplExpect.okWithAny)
                    .catch(test_1.Common.oops(this));
            });
        };
        const listRepos = () => {
            it('should list helm repos', () => {
                return test_1.CLI.command(`${helm} repo list`, this.app)
                    .then(test_1.ReplExpect.okWith('bitnami'))
                    .catch(test_1.Common.oops(this));
            });
        };
        const searchRepo = (desiredImage) => {
            it(`should search for ${desiredImage}`, () => {
                return test_1.CLI.command(`${helm} search ${desiredImage}`, this.app)
                    .then(test_1.ReplExpect.okWith(desiredImage))
                    .catch(test_1.Common.oops(this));
            });
        };
        const deleteRepo = () => {
            it('should remove a helm repo', () => {
                return test_1.CLI.command(`${helm} repo remove bitnami`, this.app)
                    .then(test_1.ReplExpect.okWithAny)
                    .catch(test_1.Common.oops(this));
            });
        };
        addRepo();
        listRepos();
        searchRepo('nginx');
        deleteRepo();
    });
});
//# sourceMappingURL=helm-repo-add-and-search.js.map