import { renderHelp } from '@kui-shell/plugin-kubeui';
import commandPrefix from '../command-prefix';
const isPlainHelm = (args) => (args.argvNoOptions.length === 1 && /^helm$/.test(args.argvNoOptions[0])) ||
    (args.argvNoOptions.length === 2 && args.argvNoOptions[0] === commandPrefix && /^helm$/.test(args.argvNoOptions[1]));
export function isUsage(args) {
    return (args.parsedOptions.help ||
        args.parsedOptions.h ||
        isPlainHelm(args) ||
        args.argvNoOptions[1] === 'help' ||
        (args.argvNoOptions[0] === commandPrefix && args.argvNoOptions[2] === 'help'));
}
export function doHelp(response) {
    throw renderHelp(response, 'helm', 'get', 500);
}
export function doHelpIfRequested(args, response) {
    if (isUsage(args)) {
        doHelp(response);
    }
    else {
        return response;
    }
}
//# sourceMappingURL=help.js.map