var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { preprocessTable, formatTable } from '@kui-shell/plugin-kubeui';
import doExecWithStdout from './exec';
import { doHelp, isUsage } from './help';
import commandPrefix from '../command-prefix';
function doRepoList(args) {
    return __awaiter(this, void 0, void 0, function* () {
        const response = yield doExecWithStdout(args);
        if (isUsage(args)) {
            doHelp(response);
        }
        const preTables = preprocessTable(response.split(/^(?=LAST SEEN|NAMESPACE|NAME\s+)/m));
        return formatTable('helm', undefined, undefined, args.parsedOptions, preTables[0]);
    });
}
export default (registrar) => {
    registrar.listen(`/${commandPrefix}/helm/repo/list`, doRepoList, {
        inBrowserOk: true
    });
    registrar.listen(`/${commandPrefix}/helm/repo/ls`, doRepoList, {
        inBrowserOk: true
    });
};
//# sourceMappingURL=repo.js.map