/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { ResourceWithMetadata } from '@kui-shell/core'
import { KubeResourceWithSummary } from '@kui-shell/plugin-kubeui'

import apiVersion from '../controller/helm/apiVersion'
const kind = 'HelmRelease'

export interface HelmRelease extends KubeResourceWithSummary {
  apiVersion
  kind
  isSimulacrum: true
}

export function isHelmRelease(resource: ResourceWithMetadata): resource is HelmRelease {
  return resource.apiVersion === apiVersion && resource.kind === kind
}
