"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function fileOf(args) {
    return args.parsedOptions.f || args.parsedOptions.filename;
}
exports.fileOf = fileOf;
function formatOf(args) {
    return args.parsedOptions.o || args.parsedOptions.output;
}
exports.formatOf = formatOf;
function isEntityFormat(format) {
    return format === 'yaml' || format === 'json';
}
exports.isEntityFormat = isEntityFormat;
function isEntityRequest(args) {
    return isEntityFormat(formatOf(args));
}
exports.isEntityRequest = isEntityRequest;
function isTableFormat(format) {
    return !format || format === 'wide' || /^custom-columns=/.test(format) || /^custom-columns-file=/.test(format);
}
function isHelpRequest(args) {
    return args.parsedOptions.help || args.parsedOptions.h;
}
exports.isHelpRequest = isHelpRequest;
function isTableRequest(args) {
    return isTableFormat(formatOf(args));
}
exports.isTableRequest = isTableRequest;
function isWatchRequest(args) {
    return args.parsedOptions.w || args.parsedOptions.watch || args.parsedOptions['watch-only'];
}
exports.isWatchRequest = isWatchRequest;
function isTableWatchRequest(args) {
    return isWatchRequest(args) && isTableRequest(args);
}
exports.isTableWatchRequest = isTableWatchRequest;
function getLabel(args) {
    return args.parsedOptions.l || args.parsedOptions.label;
}
exports.getLabel = getLabel;
function getLabelForArgv(args) {
    const label = getLabel(args);
    if (label) {
        return `-l ${label}`;
    }
    else {
        return '';
    }
}
exports.getLabelForArgv = getLabelForArgv;
function hasLabel(args) {
    if (args.parsedOptions.l || args.parsedOptions.label) {
        return true;
    }
    for (const key in args.parsedOptions) {
        if (/^l/.test(key)) {
            return true;
        }
    }
    return false;
}
exports.hasLabel = hasLabel;
function getNamespace(args) {
    return args.parsedOptions.n || args.parsedOptions.namespace;
}
exports.getNamespace = getNamespace;
function getNamespaceForArgv(args) {
    const ns = getNamespace(args);
    if (ns) {
        return `-n ${ns}`;
    }
    else {
        return '';
    }
}
exports.getNamespaceForArgv = getNamespaceForArgv;
function getContext(args) {
    return args.parsedOptions.context;
}
exports.getContext = getContext;
function getContextForArgv(args) {
    const context = getContext(args);
    if (context) {
        return `--context ${context}`;
    }
    else {
        return '';
    }
}
exports.getContextForArgv = getContextForArgv;
function isForAllNamespaces(args) {
    return args.parsedOptions.A || args.parsedOptions['all-namespaces'];
}
exports.isForAllNamespaces = isForAllNamespaces;
//# sourceMappingURL=options.js.map