"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const flags_1 = require("./flags");
const exec_1 = require("./exec");
const command_prefix_1 = require("../command-prefix");
const states_1 = require("../../lib/model/states");
function prepareArgsForStatus(cmd, args) {
    const name = args.argvNoOptions[args.argvNoOptions.indexOf(cmd) + 1];
    return `deployment ${name}`;
}
exports.doRun = (command = 'kubectl') => exec_1.doExecWithStatus('run', states_1.FinalState.OnlineLike, command, undefined, prepareArgsForStatus);
exports.default = (registrar) => {
    const handler = exports.doRun();
    registrar.listen(`/${command_prefix_1.default}/kubectl/run`, handler, flags_1.default);
    registrar.listen(`/${command_prefix_1.default}/k/run`, handler, flags_1.default);
};
//# sourceMappingURL=run.js.map