"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const fqn_1 = require("../fqn");
const debug = debug_1.default('plugin-kubeui/controller/watch/poller');
const sleepTime = 1000;
function pollUntil404(apiVersion, kind, name, namespace, offline, { REPL }, command) {
    let done = false;
    let currentTimeout;
    const poll = (iter = 0) => {
        const cmd = `${command} get ${fqn_1.default(apiVersion, kind, name, namespace)} -o custom-columns=KIND:.kind`;
        debug('poll for termination', cmd);
        REPL.qexec(cmd)
            .then(() => {
            if (!done) {
                const thisSleepTime = iter < 5 ? sleepTime : iter < 10 ? sleepTime * 2 : iter < 20 ? sleepTime * 4 : sleepTime * 10;
                currentTimeout = setTimeout(() => poll(iter + 1), thisSleepTime);
            }
        })
            .catch((err) => {
            offline(name);
            if (err.code !== 404) {
                console.error('unexpected error in pollUntil404', err);
            }
        });
    };
    poll();
    return {
        abort: () => {
            done = true;
            if (currentTimeout) {
                clearTimeout(currentTimeout);
            }
        }
    };
}
exports.default = pollUntil404;
//# sourceMappingURL=poller.js.map