"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('k8s/util/retry');
exports.withRetryOnCode = (code) => (fn, cmd) => new Promise((resolve, reject) => {
    const iter = () => __awaiter(void 0, void 0, void 0, function* () {
        try {
            resolve(yield fn());
        }
        catch (err) {
            if (err.code === code) {
                debug('retrying', cmd);
                setTimeout(iter, 5000);
            }
            else {
                debug('rejecting', err.code, err);
                reject(err);
            }
        }
    });
    iter();
});
exports.withOkOnCode = (code) => (fn, cmd) => fn().catch((err) => {
    if (err.code === code) {
        debug('404 ok', cmd);
    }
    else {
        throw err;
    }
});
exports.withOkOn404 = exports.withOkOnCode(404);
exports.withRetryOn404 = exports.withRetryOnCode(404);
//# sourceMappingURL=retry.js.map