"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const pods_1 = require("./lib/view/modes/pods");
const yaml_1 = require("./lib/view/modes/yaml");
const summary_1 = require("./lib/view/modes/summary");
const crd_summary_1 = require("./lib/view/modes/crd-summary");
const namespace_summary_1 = require("./lib/view/modes/namespace-summary");
const conditions_1 = require("./lib/view/modes/conditions");
const containers_1 = require("./lib/view/modes/containers");
const last_applied_1 = require("./lib/view/modes/last-applied");
const crud_1 = require("./lib/view/modes/crud");
const involved_object_1 = require("./lib/view/modes/involved-object");
const show_crd_managed_resources_1 = require("./lib/view/modes/show-crd-managed-resources");
const events_1 = require("./lib/view/modes/events");
const tab_completion_1 = require("./lib/tab-completion");
exports.default = (registrar) => __awaiter(void 0, void 0, void 0, function* () {
    yield registrar.registerModes(pods_1.default, yaml_1.default, events_1.eventsMode, summary_1.default, crd_summary_1.default, namespace_summary_1.default, conditions_1.default, containers_1.default, last_applied_1.default, show_crd_managed_resources_1.default, crud_1.default, involved_object_1.default);
    yield registrar.registerBadges(events_1.eventsBadge);
    try {
        tab_completion_1.default();
    }
    catch (err) {
        const debug = debug_1.default('plugins/kubeui/preload');
        debug('error installing kubeui tab-completion extensions', err);
    }
});
//# sourceMappingURL=non-headless-preload.js.map