import flags from './flags';
import { doExecWithStatus } from './exec';
import commandPrefix from '../command-prefix';
import { FinalState } from '../../lib/model/states';
function prepareArgsForDelete(args) {
    if (!Object.prototype.hasOwnProperty.call(args.parsedOptions, 'wait')) {
        return args.command + ' --wait=false';
    }
    else {
        return args.command;
    }
}
export const doDelete = (command = 'kubectl') => doExecWithStatus('delete', FinalState.OfflineLike, command, prepareArgsForDelete);
export default (registrar) => {
    const handler = doDelete();
    registrar.listen(`/${commandPrefix}/kubectl/delete`, handler, flags);
    registrar.listen(`/${commandPrefix}/k/delete`, handler, flags);
};
//# sourceMappingURL=delete.js.map