var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import flags from './flags';
import { exec, isUsage } from './exec';
import commandPrefix from '../command-prefix';
import { doGetAsEntity } from './get';
import { commandWithoutResource } from '../../lib/util/util';
function prepareArgsForDescribe(args) {
    return `${args.command.replace(/(k|kubectl|oc)(\s+)describe(\s+)/, '$1$2get$3')} -o yaml`;
}
export const doDescribe = (command = 'kubectl') => function (args) {
    return __awaiter(this, void 0, void 0, function* () {
        if (isUsage(args) || commandWithoutResource(args)) {
            return exec(args, undefined, command);
        }
        else {
            const response = yield exec(args, prepareArgsForDescribe, command);
            return doGetAsEntity(args, response);
        }
    });
};
export default (registrar) => {
    const handler = doDescribe();
    registrar.listen(`/${commandPrefix}/kubectl/describe`, handler, flags);
    registrar.listen(`/${commandPrefix}/k/describe`, handler, flags);
};
//# sourceMappingURL=describe.js.map