import flags from './flags';
import { doExecWithStatus } from './exec';
import commandPrefix from '../command-prefix';
import { FinalState } from '../../lib/model/states';
function prepareArgsForStatus(cmd, args) {
    const name = args.argvNoOptions[args.argvNoOptions.indexOf(cmd) + 1];
    return `deployment ${name}`;
}
export const doRun = (command = 'kubectl') => doExecWithStatus('run', FinalState.OnlineLike, command, undefined, prepareArgsForStatus);
export default (registrar) => {
    const handler = doRun();
    registrar.listen(`/${commandPrefix}/kubectl/run`, handler, flags);
    registrar.listen(`/${commandPrefix}/k/run`, handler, flags);
};
//# sourceMappingURL=run.js.map