var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import flags from './flags';
import { exec } from './exec';
import commandPrefix from '../command-prefix';
import { doGetAsTable } from './get';
const verb = 'top';
const doTop = (command) => function _doTop(args) {
    return __awaiter(this, void 0, void 0, function* () {
        const response = yield exec(args);
        return doGetAsTable(command, args, response, verb);
    });
};
export default (commandTree) => {
    commandTree.listen(`/${commandPrefix}/kubectl/${verb}/node`, doTop('kubectl'), flags);
    commandTree.listen(`/${commandPrefix}/k/${verb}/node`, doTop('k'), flags);
    commandTree.listen(`/${commandPrefix}/kubectl/${verb}/pod`, doTop('kubectl'), flags);
    commandTree.listen(`/${commandPrefix}/k/${verb}/pod`, doTop('k'), flags);
};
//# sourceMappingURL=top.js.map