var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { registerTabCompletionEnumerator } from '@kui-shell/plugin-core-support/tab-completion';
import { getCommandFromArgs } from './util/util';
function getMatchingStrings(tab, cmd, spec) {
    return __awaiter(this, void 0, void 0, function* () {
        const completions = yield tab.REPL.qexec(cmd, undefined, undefined, { raw: true });
        const list = completions.split(/[\n\r]/).map(_ => _.replace(/^\w+\//, ''));
        return list.filter(name => name.startsWith(spec.toBeCompleted));
    });
}
function optionals(commandLine, filter = () => true) {
    const options = commandLine.parsedOptions;
    return Object.keys(options)
        .filter(filter)
        .filter(_ => !/^(-o|--output)/.test(_))
        .map(key => `${key.length === 1 ? `-${key}` : `--${key}`} ${options[key]}`)
        .join(' ');
}
function completeResourceNames(tab, commandLine, spec) {
    return __awaiter(this, void 0, void 0, function* () {
        const { argvNoOptions, argv, parsedOptions } = commandLine;
        const command = getCommandFromArgs({ argvNoOptions });
        const previous = spec.toBeCompletedIdx === -1 ? commandLine.argv.length - 1 : spec.toBeCompletedIdx - 1;
        if (previous > 0 && (argv[previous] === '-n' || argv[previous] === '--namespace')) {
            const cmd = `${command} get ns ${optionals(commandLine, _ => _ !== '-n' && _ !== '--namespace')} -o name`;
            return getMatchingStrings(tab, cmd, spec);
        }
        else if ((argvNoOptions[0] === 'kubectl' || argvNoOptions[0] === 'k' || argvNoOptions[0] === 'oc') &&
            (argvNoOptions[1] === 'get' ||
                argvNoOptions[1] === 'describe' ||
                argvNoOptions[1] === 'annotate' ||
                argvNoOptions[1] === 'label' ||
                (argvNoOptions[1] === 'delete' && !parsedOptions.f && !parsedOptions.file))) {
            const entityType = argvNoOptions[2];
            const cmd = `${command} get ${entityType} ${optionals(commandLine)} -o name`;
            return getMatchingStrings(tab, cmd, spec);
        }
    });
}
export default () => {
    registerTabCompletionEnumerator(completeResourceNames);
};
//# sourceMappingURL=tab-completion.js.map