import { i18n } from '@kui-shell/core';
import cssForValue from '../css-for-value';
import TrafficLight from '../../model/traffic-light';
import { isEvent, isCrudableKubeResource, isNamespaced } from '../../model/resource';
import { getCommandFromArgs } from '../../util/util';
const strings = i18n('plugin-kubeui');
function command(tab, resource, args) {
    const cmdGetPodEvents = `${getCommandFromArgs(args)} get events --field-selector involvedObject.name=${resource.metadata.name},involvedObject.namespace=${resource.metadata.namespace} -n ${resource.metadata.namespace}`;
    const customColumns = 'wide';
    return `${cmdGetPodEvents} -o "${customColumns}"`;
}
function hasEvents(resource) {
    return isCrudableKubeResource(resource) && !isEvent(resource) && isNamespaced(resource);
}
export const eventsMode = {
    when: hasEvents,
    mode: {
        mode: 'events',
        label: strings('Show Events'),
        command,
        kind: 'drilldown'
    }
};
export const eventsBadge = {
    when: isEvent,
    badge: (event) => {
        const cssFromReason = cssForValue[event.reason];
        return {
            title: cssFromReason ? event.reason : event.type,
            css: cssFromReason ||
                (event.type === 'Error' ? TrafficLight.Red : event.type === 'Warning' ? TrafficLight.Yellow : undefined)
        };
    }
};
//# sourceMappingURL=events.js.map