import { i18n, encodeComponent } from '@kui-shell/core';
import { isCustomResourceDefinition } from '../../model/resource';
import { fqn } from '../../../controller/kubectl/fqn';
import { getCommandFromArgs } from '../../../lib/util/util';
const strings = i18n('plugin-kubeui');
export function command(tab, crd, args) {
    return `${getCommandFromArgs(args)} get ${fqn(crd.apiVersion, encodeComponent(crd.kind), encodeComponent(crd.metadata.name), encodeComponent(crd.metadata.namespace || 'default'))}`;
}
const mode = {
    when: isCustomResourceDefinition,
    mode: {
        mode: 'show-crd-resources',
        label: strings('Show Resources'),
        command,
        kind: 'drilldown'
    }
};
export default mode;
//# sourceMappingURL=show-crd-managed-resources.js.map