var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import Debug from 'debug';
import podMode from './lib/view/modes/pods';
import yamlMode from './lib/view/modes/yaml';
import summaryMode from './lib/view/modes/summary';
import crdSummaryMode from './lib/view/modes/crd-summary';
import namespaceSummaryMode from './lib/view/modes/namespace-summary';
import conditionsMode from './lib/view/modes/conditions';
import containersMode from './lib/view/modes/containers';
import lastAppliedMode from './lib/view/modes/last-applied';
import deleteResourceMode from './lib/view/modes/crud';
import involvedObjectMode from './lib/view/modes/involved-object';
import showCRDResources from './lib/view/modes/show-crd-managed-resources';
import { eventsMode, eventsBadge } from './lib/view/modes/events';
import tabCompletionProvider from './lib/tab-completion';
export default (registrar) => __awaiter(void 0, void 0, void 0, function* () {
    yield registrar.registerModes(podMode, yamlMode, eventsMode, summaryMode, crdSummaryMode, namespaceSummaryMode, conditionsMode, containersMode, lastAppliedMode, showCRDResources, deleteResourceMode, involvedObjectMode);
    yield registrar.registerBadges(eventsBadge);
    try {
        tabCompletionProvider();
    }
    catch (err) {
        const debug = Debug('plugins/kubeui/preload');
        debug('error installing kubeui tab-completion extensions', err);
    }
});
//# sourceMappingURL=non-headless-preload.js.map