var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, SidecarExpect, Selectors } from '@kui-shell/test';
import { waitForGreen, waitForRed, defaultModeForGet, createNS, allocateNS, deleteNS } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
import { dirname } from 'path';
const ROOT = dirname(require.resolve('@kui-shell/plugin-kubeui/tests/package.json'));
const commands = ['kubectl'];
if (process.env.NEEDS_OC) {
    commands.push('oc');
}
const dashFs = ['-f', '--filename'];
commands.forEach(command => {
    describe(`${command} create pod ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
        before(Common.before(this));
        after(Common.after(this));
        dashFs.forEach(dashF => {
            const ns = createNS();
            const inNamespace = `-n ${ns}`;
            allocateNS(this, ns, command);
            it(`should create sample pod from URL via ${command}`, () => __awaiter(this, void 0, void 0, function* () {
                try {
                    const selector = yield CLI.command(`${command} create ${dashF} https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod ${inNamespace}`, this.app).then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }));
                    yield waitForGreen(this.app, selector);
                    yield this.app.client.click(`${selector} .clickable`);
                    yield SidecarExpect.open(this.app)
                        .then(SidecarExpect.mode(defaultModeForGet))
                        .then(SidecarExpect.showing('nginx'));
                }
                catch (err) {
                    yield Common.oops(this, true)(err);
                }
            }));
            it(`should delete the sample pod from URL via ${command}`, () => {
                return CLI.command(`${command} delete ${dashF} https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod ${inNamespace}`, this.app)
                    .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }))
                    .then(selector => waitForRed(this.app, selector))
                    .catch(Common.oops(this));
            });
            it(`should create sample pod from local file via ${command}`, () => {
                return CLI.command(`${command} create ${dashF} "${ROOT}/data/k8s/headless/pod.yaml" ${inNamespace}`, this.app)
                    .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }))
                    .then(selector => waitForGreen(this.app, selector))
                    .catch(Common.oops(this));
            });
            it(`should delete the sample pod by name via ${command}`, () => {
                return CLI.command(`${command} delete pod nginx ${inNamespace}`, this.app)
                    .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }))
                    .then(selector => waitForRed(this.app, selector))
                    .catch(Common.oops(this));
            });
            deleteNS(this, ns, command);
        });
    });
});
//# sourceMappingURL=create-pod.js.map