var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, SidecarExpect, Selectors, Util } from '@kui-shell/test';
import { waitForGreen, defaultModeForGet, createNS, allocateNS, deleteNS, singletonTablesHaveTitle, waitTillNone } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
import * as assert from 'assert';
import { dirname } from 'path';
const ROOT = dirname(require.resolve('@kui-shell/plugin-kubeui/tests/package.json'));
const ns = createNS();
const inNamespace = `-n ${ns}`;
describe(`kubectl deployment ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    const createIt = () => {
        it('should create deployment from local file', () => __awaiter(this, void 0, void 0, function* () {
            try {
                const selector = yield CLI.command(`kubectl create -f ${ROOT}/data/k8s/deployment.yaml ${inNamespace}`, this.app).then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('myapp') }));
                yield waitForGreen(this.app, selector);
                yield this.app.client.click(`${selector} [data-value="myapp"].clickable`);
                yield SidecarExpect.open(this.app)
                    .then(SidecarExpect.mode(defaultModeForGet))
                    .then(SidecarExpect.showing('myapp', undefined, undefined, ns));
            }
            catch (err) {
                return Common.oops(this)(err);
            }
        }));
    };
    const listIt = () => {
        it('should list deployments', () => __awaiter(this, void 0, void 0, function* () {
            try {
                const selector = yield CLI.command(`kubectl get deployment ${inNamespace}`, this.app).then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('myapp') }));
                yield this.app.client.click(`${selector} [data-value="myapp"].clickable`);
                const selectorPrefix = selector.replace(Selectors.BY_NAME('myapp'), '');
                if (singletonTablesHaveTitle) {
                    yield this.app.client
                        .getText(`${selectorPrefix} .result-table-title`)
                        .then((title) => assert.ok(title === 'DEPLOYMENT'));
                }
                yield SidecarExpect.open(this.app)
                    .then(SidecarExpect.mode(defaultModeForGet))
                    .then(SidecarExpect.showing('myapp', undefined, undefined, ns))
                    .then(() => this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON_SELECTED('summary')))
                    .then(() => this.app)
                    .then(Util.getValueFromMonaco)
                    .then(Util.expectYAMLSubset({ NAME: 'myapp' }))
                    .then(() => new Promise(resolve => setTimeout(resolve, 1000)))
                    .then(() => this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON('pods')))
                    .then(() => this.app.client.click(Selectors.SIDECAR_MODE_BUTTON('pods')))
                    .then(() => this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON_SELECTED('pods')))
                    .then(() => this.app.client.waitForExist(`${Selectors.SIDECAR_CUSTOM_CONTENT} .bx--data-table`))
                    .then(() => __awaiter(this, void 0, void 0, function* () {
                    if (singletonTablesHaveTitle) {
                        const actualTitle = yield this.app.client.getText(`${Selectors.SIDECAR_CUSTOM_CONTENT} .result-table-title`);
                        assert.strictEqual(actualTitle, 'PODS');
                    }
                }));
            }
            catch (err) {
                return Common.oops(this)(err);
            }
        }));
    };
    const deleteItByName = () => {
        it('should delete the deployment by name', () => {
            return CLI.command(`kubectl delete deployment myapp ${inNamespace}`, this.app)
                .then(ReplExpect.okWithAny)
                .then(() => waitTillNone('deployment', undefined, 'myapp', undefined, inNamespace))
                .catch(Common.oops(this));
        });
    };
    const deleteItByClickingOnButton = () => {
        it('should delete the deployment by clicking on the sidecar delete button', () => __awaiter(this, void 0, void 0, function* () {
            try {
                yield this.app.client.click(Selectors.SIDECAR_MODE_BUTTON('delete'));
                yield this.app.client.waitForExist('#confirm-dialog');
                yield this.app.client.click('#confirm-dialog .bx--btn--danger');
                yield waitTillNone('deployment', undefined, 'myapp', undefined, inNamespace);
            }
            catch (err) {
                return Common.oops(this)(err);
            }
        }));
    };
    allocateNS(this, ns);
    createIt();
    listIt();
    deleteItByName();
    createIt();
    deleteItByClickingOnButton();
    deleteNS(this, ns);
});
//# sourceMappingURL=deployment.js.map