var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, SidecarExpect, Selectors } from '@kui-shell/test';
import { waitForGreen, waitForRed, createNS as create, defaultModeForGet } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
const nsName = create();
var Status;
(function (Status) {
    Status["Offline"] = "red-background";
    Status["Online"] = "green-background";
})(Status || (Status = {}));
const waitForStatus = function (status, nsName, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const selector = yield ReplExpect.okWithCustom({
            selector: Selectors.BY_NAME(nsName)
        })(res);
        if (status === Status.Offline) {
            return waitForRed(this.app, selector);
        }
        else {
            return waitForGreen(this.app, selector);
        }
    });
};
const createNS = function (kubectl) {
    return __awaiter(this, void 0, void 0, function* () {
        it(`should create namespace from URL via ${kubectl}`, () => __awaiter(this, void 0, void 0, function* () {
            const waitForOnline = waitForStatus.bind(this, Status.Online, nsName);
            try {
                yield waitForOnline(yield CLI.command(`${kubectl} create ns ${nsName}`, this.app));
            }
            catch (err) {
                yield Common.oops(this, false)(err);
            }
        }));
    });
};
const deleteNS = function (kubectl) {
    it(`should delete the namespace ${nsName} from URL via ${kubectl}`, () => __awaiter(this, void 0, void 0, function* () {
        try {
            const waitForOffline = waitForStatus.bind(this, Status.Offline, nsName);
            const res = yield CLI.command(`${kubectl} delete ns ${nsName}`, this.app);
            yield waitForOffline(res);
        }
        catch (err) {
            yield Common.oops(this, false)(err);
        }
    }));
};
const testDrilldown = (nsName, res) => __awaiter(void 0, void 0, void 0, function* () {
    const selector = yield ReplExpect.okWithCustom({
        selector: Selectors.BY_NAME(nsName)
    })(res);
    yield res.app.client.click(`${selector} .entity-name`);
    yield SidecarExpect.open(res.app)
        .then(SidecarExpect.mode(defaultModeForGet))
        .then(SidecarExpect.showing(nsName));
    yield res.app.client.click(Selectors.SIDECAR_FULLY_CLOSE_BUTTON);
    yield SidecarExpect.closed(res.app);
});
const watchNS = function (kubectl) {
    const watchCmds = [
        `${kubectl} get ns -w`,
        `${kubectl} get ns ${nsName} -w`,
        `${kubectl} get -w=true --watch ns ${nsName} --watch=true -w`
    ];
    watchCmds.forEach((_watchCmd, idx) => {
        const nsNameForIter = `${nsName}-${idx}`;
        const watchCmd = _watchCmd.replace(nsName, nsNameForIter);
        it('should reload', () => Common.refresh(this));
        it(`should watch namespaces via ${watchCmd}`, () => __awaiter(this, void 0, void 0, function* () {
            try {
                const waitForOnline = waitForStatus.bind(this, Status.Online, nsNameForIter);
                const waitForOffline = waitForStatus.bind(this, Status.Offline, nsNameForIter);
                const createBadge = yield waitForOnline(yield CLI.command(`${kubectl} create ns ${nsNameForIter}`, this.app));
                const testWatch = yield CLI.command(watchCmd, this.app);
                const watchBadge = yield waitForOnline(testWatch);
                const watchBadgeButOffline = watchBadge.replace(Status.Online, Status.Offline);
                yield testDrilldown(nsNameForIter, testWatch);
                const deleteBadge = yield waitForOffline(yield CLI.command(`${kubectl} delete ns ${nsNameForIter}`, this.app));
                yield this.app.client.waitForExist(createBadge);
                yield this.app.client.waitForExist(deleteBadge);
                yield this.app.client.waitForExist(watchBadge, 20000, true);
                yield this.app.client.waitForExist(watchBadgeButOffline);
                yield waitForOnline(yield CLI.command(`${kubectl} create ns ${nsNameForIter}`, this.app));
                yield this.app.client.waitForExist(watchBadge);
                yield this.app.client.waitForExist(watchBadgeButOffline, 20000, true);
                yield waitForOffline(yield CLI.command(`${kubectl} delete ns ${nsNameForIter}`, this.app));
                yield this.app.client.waitForExist(watchBadge, 20000, true);
                yield this.app.client.waitForExist(watchBadgeButOffline);
            }
            catch (err) {
                yield Common.oops(this, false)(err);
            }
        }));
    });
};
const synonyms = ['kubectl'];
describe(`kubectl watch namespace ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    synonyms.forEach(kubectl => {
        const createIt = createNS.bind(this, kubectl);
        const deleteIt = deleteNS.bind(this, kubectl);
        const watchIt = watchNS.bind(this, kubectl);
        createIt();
        deleteIt();
        watchIt();
    });
});
//# sourceMappingURL=get-namespaces-with-watch.js.map