import { Common, CLI, ReplExpect, Selectors } from '@kui-shell/test';
import { waitForGreen, createNS, allocateNS, deleteNS } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
const synonyms = ['kubectl', 'k'];
describe(`kubectl run ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    synonyms.forEach(kubectl => {
        const ns = createNS();
        allocateNS(this, ns);
        it(`should create deployment from ${kubectl} run`, () => {
            return CLI.command(`${kubectl} run nginx --image nginx -n ${ns}`, this.app)
                .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }))
                .then(selector => waitForGreen(this.app, selector))
                .catch(Common.oops(this));
        });
        it(`should delete the deployment by name via ${kubectl}`, () => {
            return CLI.command(`${kubectl} delete deployment nginx -n ${ns}`, this.app)
                .then(ReplExpect.okWithAny)
                .catch(Common.oops(this));
        });
        deleteNS(this, ns);
    });
});
//# sourceMappingURL=run.js.map