var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, SidecarExpect, Selectors } from '@kui-shell/test';
import { waitForGreen, waitForRed, defaultModeForGet, createNS as create, waitTillNone } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
const synonyms = ['kubectl'];
describe(`kubectl get all-namespaces ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    synonyms.forEach(kubectl => {
        const createNs = (name) => {
            it(`should create namespace ${name} via ${kubectl}`, () => {
                return CLI.command(`${kubectl} create namespace ${name}`, this.app)
                    .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME(name) }))
                    .then(selector => waitForGreen(this.app, selector))
                    .catch(Common.oops(this, true));
            });
        };
        const createPod = (ns) => {
            it(`should create sample pod in namespace ${ns} from URL via ${kubectl}`, () => {
                return CLI.command(`${kubectl} create -f https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod -n ${ns}`, this.app)
                    .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }))
                    .then(selector => waitForGreen(this.app, selector))
                    .catch(Common.oops(this, true));
            });
        };
        const listAndClickOn = (ns) => {
            it(`should list pods --all-namespaces expecting ns ${ns} via ${kubectl} then click`, () => __awaiter(this, void 0, void 0, function* () {
                try {
                    const selector = yield CLI.command(`${kubectl} get pods --all-namespaces`, this.app).then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME(ns) }));
                    yield waitForGreen(this.app, selector);
                    yield this.app.client.waitForExist(`${selector} .clickable[data-key="NAME"]`);
                    yield this.app.client.click(`${selector} .clickable`);
                    yield SidecarExpect.open(this.app)
                        .then(SidecarExpect.mode(defaultModeForGet))
                        .then(SidecarExpect.showing('nginx', undefined, undefined, ns));
                }
                catch (err) {
                    return Common.oops(this, true)(err);
                }
            }));
        };
        const deleteNs = (name) => {
            it(`should delete the namespace ${name} via ${kubectl}`, () => {
                return CLI.command(`${kubectl} delete namespace ${name}`, this.app)
                    .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME(name) }))
                    .then(selector => waitForRed(this.app, selector))
                    .then(() => waitTillNone('namespace', undefined, name))
                    .catch(Common.oops(this, true));
            });
        };
        const deletePod = (ns) => {
            it(`should delete the pod in ns ${ns} by name via ${kubectl}`, () => {
                return CLI.command(`${kubectl} delete pod nginx -n ${ns}`, this.app)
                    .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }))
                    .then(selector => waitForRed(this.app, selector))
                    .catch(Common.oops(this, true));
            });
        };
        const ns1 = create();
        const ns2 = create();
        createNs(ns1);
        createNs(ns2);
        createPod(ns1);
        createPod(ns2);
        listAndClickOn(ns1);
        listAndClickOn(ns2);
        deletePod(ns1);
        deletePod(ns2);
        deleteNs(ns1);
        deleteNs(ns2);
    });
});
//# sourceMappingURL=get-all-namespaces.js.map