var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, SidecarExpect, Selectors } from '@kui-shell/test';
import { waitForGreen, waitForRed, defaultModeForGet, createNS, allocateNS, deleteNS } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
import * as assert from 'assert';
const commands = ['kubectl'];
if (process.env.NEEDS_OC) {
    commands.push('oc');
}
commands.forEach(command => {
    describe(`${command} get pod ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
        before(Common.before(this));
        after(Common.after(this));
        const testContainersTab = (click = true) => __awaiter(this, void 0, void 0, function* () {
            if (click) {
                yield this.app.client.click(Selectors.SIDECAR_MODE_BUTTON('containers'));
            }
            yield this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON_SELECTED('containers'));
            const table = `${Selectors.SIDECAR} .bx--data-table`;
            yield this.app.client.waitForVisible(table);
            yield this.app.client.waitForVisible(`${table} .entity[data-name="nginx"] [data-key="ready"][data-value="true"]`);
            const message = yield this.app.client.getText(`${table} .entity[data-name="nginx"] [data-key="message"]`);
            assert.ok(!/Initializing/i.test(message));
            yield this.app.client.waitForVisible(`${table} .entity[data-name="nginx"] [data-key="ready"].green-text .cell-inner.graphical-icon`);
        });
        const ns = createNS();
        const inNamespace = `-n ${ns}`;
        allocateNS(this, ns);
        it('should error out when getting non-existent pod', () => {
            const noName = 'shouldNotExist';
            return CLI.command(`${command} get pod ${noName}`, this.app)
                .then(ReplExpect.error(404, `Error from server (NotFound): pods "${noName}" not found`))
                .catch(Common.oops(this, true));
        });
        it('should error out when getting non-existent pod, with incorrect comment space', () => {
            const noName = 'shouldNotExist#comment';
            return CLI.command(`${command} get pod ${noName}`, this.app)
                .then(ReplExpect.error(404, `Error from server (NotFound): pods "${noName}" not found`))
                .catch(Common.oops(this, true));
        });
        it('should error out when getting non-existent pod, with correct comment', () => {
            const noName = 'shouldNotExist';
            return CLI.command(`${command} get pod ${noName} #comment`, this.app)
                .then(ReplExpect.error(404, `Error from server (NotFound): pods "${noName}" not found`))
                .catch(Common.oops(this, true));
        });
        it('should error out when getting 2 non-existent pods', () => {
            const noName1 = 'shouldNotExist1';
            const noName2 = 'shouldNotExist2';
            return CLI.command(`${command} get pod ${noName1} ${noName2}`, this.app)
                .then(ReplExpect.error(404))
                .catch(Common.oops(this, true));
        });
        it('should error out when getting pods with incorrect comments', () => {
            return CLI.command(`${command} get pod# comment #comment`, this.app)
                .then(ReplExpect.error(404, 'error: the server doesn\'t have a resource type "pod#"'))
                .catch(Common.oops(this, true));
        });
        it(`should show ready containers if we click after creation`, () => __awaiter(this, void 0, void 0, function* () {
            try {
                const selector = yield CLI.command(`${command} create -f https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod ${inNamespace}`, this.app).then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }));
                yield waitForGreen(this.app, selector);
                yield this.app.client.waitForExist(`${selector} .clickable`);
                yield this.app.client.click(`${selector} .clickable`);
                yield SidecarExpect.open(this.app)
                    .then(SidecarExpect.mode(defaultModeForGet))
                    .then(SidecarExpect.showing('nginx'));
                yield testContainersTab();
            }
            catch (err) {
                return Common.oops(this, true)(err);
            }
        }));
        const getListAsYAMLCommand = `${command} get pods -o yaml ${inNamespace}`;
        it(`should get a list of pods in yaml form via ${getListAsYAMLCommand}`, () => {
            return CLI.command(getListAsYAMLCommand, this.app)
                .then(ReplExpect.justOK)
                .then(SidecarExpect.open)
                .then(SidecarExpect.mode('raw'))
                .then(SidecarExpect.showing(getListAsYAMLCommand))
                .catch(Common.oops(this, true));
        });
        it(`should delete the sample pod from URL via ${command}`, () => {
            return CLI.command(`${command} delete -f https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod ${inNamespace}`, this.app)
                .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }))
                .then(selector => waitForRed(this.app, selector))
                .catch(Common.oops(this, true));
        });
        it(`should create sample pod from URL via ${command}`, () => {
            return CLI.command(`${command} create -f https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod ${inNamespace}`, this.app)
                .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }))
                .then((selector) => waitForGreen(this.app, selector))
                .catch(Common.oops(this, true));
        });
        it(`should get the pod with ${command} ${inNamespace} pod`, () => {
            return CLI.command(`${command} get ${inNamespace} pod nginx`, this.app)
                .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }))
                .then((selector) => waitForGreen(this.app, selector))
                .catch(Common.oops(this, true));
        });
        it(`should list pods via ${command} then click`, () => __awaiter(this, void 0, void 0, function* () {
            try {
                const selector = yield CLI.command(`${command} get pods ${inNamespace}`, this.app).then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }));
                yield waitForGreen(this.app, selector);
                yield this.app.client.click(`${selector} .clickable`);
                yield SidecarExpect.open(this.app)
                    .then(SidecarExpect.mode(defaultModeForGet))
                    .then(SidecarExpect.showing('nginx'));
            }
            catch (err) {
                return Common.oops(this, true)(err);
            }
        }));
        it('should click on the sidecar maximize button', () => __awaiter(this, void 0, void 0, function* () {
            try {
                yield this.app.client.click(Selectors.SIDECAR_MAXIMIZE_BUTTON);
                yield this.app.client.waitForExist(Selectors.SIDECAR_FULLSCREEN);
            }
            catch (err) {
                return Common.oops(this, true)(err);
            }
        }));
        it('should click on the sidecar maximize button to restore split screen', () => __awaiter(this, void 0, void 0, function* () {
            try {
                yield this.app.client.click(Selectors.SIDECAR_MAXIMIZE_BUTTON);
                yield this.app.client.waitForExist(Selectors.SIDECAR_FULLSCREEN, 20000, true);
            }
            catch (err) {
                return Common.oops(this, true)(err);
            }
        }));
        it(`should click on containers sidecar tab and show containers table`, testContainersTab);
        it('should transition back from log and see containers table', testContainersTab.bind(this, false));
        it(`should be able to show table with grep`, () => __awaiter(this, void 0, void 0, function* () {
            try {
                const res = yield CLI.command(`${command} get pods ${inNamespace} | grep nginx`, this.app);
                const rows = Selectors.xtermRows(res.count);
                yield this.app.client.waitForExist(rows);
                yield ReplExpect.okWithString('nginx');
            }
            catch (err) {
                return Common.oops(this, true)(err);
            }
        }));
        it(`should delete the sample pod from URL via ${command}`, () => {
            return CLI.command(`${command} delete -f https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod ${inNamespace}`, this.app)
                .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }))
                .then((selector) => waitForRed(this.app, selector))
                .catch(Common.oops(this, true));
        });
        deleteNS(this, ns);
    });
});
//# sourceMappingURL=get-pod.js.map