var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, Keys, ReplExpect, Selectors } from '@kui-shell/test';
import { waitForGreen, createNS, allocateNS, deleteNS, typeSlowly } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
import { readFileSync } from 'fs';
import { dirname, join } from 'path';
const ROOT = dirname(require.resolve('@kui-shell/plugin-kubeui/tests/package.json'));
const inputBuffer = readFileSync(join(ROOT, 'data/k8s/kubectl-exec.yaml'));
const inputEncoded = inputBuffer.toString('base64');
describe(`kubectl exec vi ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    const ns = createNS();
    allocateNS(this, ns);
    const podName = 'vim';
    it(`should create sample pod from URL`, () => {
        return CLI.command(`echo ${inputEncoded} | base64 --decode | kubectl create -f - -n ${ns}`, this.app)
            .then(ReplExpect.okWithString(podName))
            .catch(Common.oops(this));
    });
    it(`should wait for the pod to come up`, () => {
        return CLI.command(`kubectl get pod ${podName} -n ${ns} -w`, this.app)
            .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME(podName) }))
            .then(selector => waitForGreen(this.app, selector))
            .catch(Common.oops(this));
    });
    const filename = '/tmp/foo.txt';
    const typeThisText = 'hello there';
    it(`should use kubectl exec vi through pty`, () => __awaiter(this, void 0, void 0, function* () {
        try {
            const res = yield CLI.command(`kubectl exec -it ${podName} -n ${ns} -- vim -i NONE ${filename}`, this.app);
            const rows = Selectors.xtermRows(res.count);
            const lastRowSelector = `${rows} > div:last-child`;
            const lastRow = () => __awaiter(this, void 0, void 0, function* () {
                return this.app.client.getText(lastRowSelector);
            });
            yield this.app.client.waitForExist(rows);
            yield this.app.client.waitForExist(`tab.visible.xterm-alt-buffer-mode`);
            let iter = 0;
            yield this.app.client.keys('i');
            yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const txt = yield lastRow();
                if (++iter > 5) {
                    console.error('kubectl exec vi still waiting for Insert mode', txt);
                }
                return /INSERT/i.test(txt);
            }));
            yield typeSlowly(this.app, typeThisText);
            iter = 0;
            yield this.app.client.keys(Keys.ESCAPE);
            yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const txt = yield lastRow();
                if (++iter > 5) {
                    console.error('kubectl exec vi still waiting to exit insert mode', txt);
                }
                return !/INSERT/i.test(txt);
            }));
            iter = 0;
            yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                yield this.app.client.keys(Keys.ESCAPE);
                yield typeSlowly(this.app, `:wq${Keys.ENTER}`);
                try {
                    yield this.app.client.waitForVisible(Selectors.PROMPT_N(res.count + 1), 5000);
                    return true;
                }
                catch (err) {
                    console.error(`hmm, prompt block not yet visible at iter ${iter++}`);
                    return false;
                }
            }));
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
    it('should use kubectl exec to cat the file we just edited', () => __awaiter(this, void 0, void 0, function* () {
        return CLI.command(`kubectl exec ${podName} -n ${ns} -- cat ${filename}`, this.app)
            .then(ReplExpect.okWithString(typeThisText))
            .catch(Common.oops(this, true));
    }));
    deleteNS(this, ns);
});
//# sourceMappingURL=kubectl-exec-vi.js.map