var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, SidecarExpect, Selectors } from '@kui-shell/test';
import { waitForGreen, defaultModeForGet, createNS, allocateNS, deleteNS } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
const synonyms = ['kubectl'];
const dashFs = ['-f'];
const echoString = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';
xdescribe(`kubectl semicolons ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    synonyms.forEach(kubectl => {
        dashFs.forEach(dashF => {
            const ns = createNS();
            const inNamespace = `-n ${ns}`;
            allocateNS(this, ns);
            it(`should create sample pod from URL via ${kubectl}`, () => __awaiter(this, void 0, void 0, function* () {
                try {
                    const selector = yield CLI.command(`${kubectl} create ${dashF} https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod ${inNamespace}`, this.app).then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }));
                    yield waitForGreen(this.app, selector);
                    yield this.app.client.click(`${selector} .clickable`);
                    yield SidecarExpect.open(this.app)
                        .then(SidecarExpect.mode(defaultModeForGet))
                        .then(SidecarExpect.showing('nginx'));
                }
                catch (err) {
                    yield Common.oops(this, true)(err);
                }
            }));
            it(`should get with semicolon 1`, () => {
                return CLI.command(`${kubectl} get pods -n ${ns}; echo ${echoString}`, this.app)
                    .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }))
                    .then(selector => waitForGreen(this.app, selector))
                    .catch(Common.oops(this, true));
            });
            it(`should get with semicolon 2`, () => {
                return CLI.command(`${kubectl} get pods -n ${ns} ; echo ${echoString}`, this.app)
                    .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }))
                    .then(selector => waitForGreen(this.app, selector))
                    .catch(Common.oops(this, true));
            });
            it(`should get with semicolon 3`, () => {
                return CLI.command(`${kubectl} get pods -n ${ns} ;echo ${echoString};`, this.app)
                    .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }))
                    .then(selector => waitForGreen(this.app, selector))
                    .catch(Common.oops(this, true));
            });
            it(`should get with semicolon 4`, () => {
                return CLI.command(`${kubectl} get pods -n ${ns} ;echo ${echoString}; ; ; ;;;`, this.app)
                    .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }))
                    .then(selector => waitForGreen(this.app, selector))
                    .catch(Common.oops(this, true));
            });
            it(`should get with semicolon 5`, () => {
                return CLI.command(`${kubectl} get pods -n ${ns} ;echo ${echoString}; ; ; ;;;`, this.app)
                    .then(ReplExpect.okWithString(echoString))
                    .catch(Common.oops(this, true));
            });
            deleteNS(this, ns);
        });
    });
});
//# sourceMappingURL=semicolons.js.map