"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const resource_1 = require("../models/resource");
const strings = core_1.i18n('plugin-logui');
function hasError(resource) {
    return (resource_1.isLogEntryResource(resource) &&
        resource.spec.entry.messageDetail !== undefined &&
        resource.spec.entry.messageDetail.error !== undefined);
}
function renderError(tab, resource) {
    return resource.spec.entry.messageDetail.error;
}
exports.default = {
    when: hasError,
    mode: {
        mode: 'error-verbose',
        label: strings('Error'),
        content: renderError,
        order: -2
    }
};
//# sourceMappingURL=error-verbose.js.map