"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const plugin_kubeui_1 = require("@kui-shell/plugin-kubeui");
const resource_1 = require("../models/resource");
const levelBadge = {
    when: resource_1.isLogEntryResource,
    badge: (resource) => {
        const level = resource.spec.entry.level;
        return {
            title: level,
            css: level === 'WARN' ? plugin_kubeui_1.TrafficLight.Yellow : level === 'ERROR' ? plugin_kubeui_1.TrafficLight.Red : undefined
        };
    }
};
exports.default = levelBadge;
//# sourceMappingURL=level-badge.js.map