import Debug from 'debug';
import { i18n } from '@kui-shell/core';
const debug = Debug('plugin-logui/formats/json');
const strings = i18n('plugin-kubeui');
export default {
    entry: (line) => {
        try {
            const record = JSON.parse(line);
            const base = {
                level: record.level.toUpperCase(),
                timestamp: new Date(1000 * parseFloat(record.ts)).toLocaleString(),
                detail1: record.logger,
                detail1Key: strings('Logger'),
                message: record.msg
            };
            const rest = Object.assign({}, record);
            delete rest.level;
            delete rest.logger;
            delete rest.msg;
            delete rest.ts;
            if (Object.keys(rest).length > 0) {
                return Object.assign(base, {
                    messageDetail: rest
                });
            }
            else {
                return base;
            }
        }
        catch (err) {
            debug('error parsing json', line, err);
            return undefined;
        }
    }
};
//# sourceMappingURL=json.js.map