var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { i18n } from '@kui-shell/core';
import { doExecRaw } from '@kui-shell/plugin-kubeui';
import { formatAsTable } from '../renderers/table';
const strings = i18n('plugin-logui');
function isLogs(resource) {
    return resource.kind === 'logs';
}
function renderPrevious(tab, resource) {
    return __awaiter(this, void 0, void 0, function* () {
        return formatAsTable(yield doExecRaw(`${resource.originatingCommand} --previous`, {}, {}), resource.metadata);
    });
}
export default {
    when: isLogs,
    mode: {
        mode: 'previous',
        label: strings('Previous'),
        content: renderPrevious,
        priority: 10
    }
};
//# sourceMappingURL=previous.js.map