var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import * as assert from 'assert';
import { Common, CLI, Keys, ReplExpect, Selectors } from '@kui-shell/test';
import { waitForGreen, createNS, allocateNS, deleteNS } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
import { readFileSync } from 'fs';
import { dirname, join } from 'path';
const ROOT = dirname(require.resolve('@kui-shell/plugin-kubeui/tests/package.json'));
const inputBuffer = readFileSync(join(ROOT, 'data/k8s/kubectl-exec.yaml'));
const inputEncoded = inputBuffer.toString('base64');
const sleepTime = 8;
function getTextContent(app, selector) {
    return app.client.getText(selector);
}
function sleep(N) {
    return new Promise(resolve => setTimeout(resolve, N * 1000));
}
const commands = ['kubectl'];
if (process.env.NEEDS_OC) {
    commands.push('oc');
}
commands.forEach(command => {
    describe(`${command} logs follow ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
        before(Common.before(this));
        after(Common.after(this));
        const ns = createNS();
        allocateNS(this, ns);
        const podName = 'vim';
        const containerName = 'alpine';
        it(`should create sample pod from URL`, () => {
            return CLI.command(`echo ${inputEncoded} | base64 --decode | ${command} create -f - -n ${ns}`, this.app)
                .then(ReplExpect.okWithString(podName))
                .catch(Common.oops(this, true));
        });
        it(`should wait for the pod to come up`, () => {
            return CLI.command(`${command} get pod ${podName} -n ${ns} -w`, this.app)
                .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME(podName) }))
                .then(selector => waitForGreen(this.app, selector))
                .catch(Common.oops(this, true));
        });
        it(`should follow the logs`, () => __awaiter(this, void 0, void 0, function* () {
            try {
                const res = yield CLI.command(`${command} logs ${podName} -c ${containerName} -n ${ns} -f`, this.app);
                const rows = Selectors.OUTPUT_N_STREAMING(res.count);
                yield sleep(sleepTime);
                const text1 = yield getTextContent(this.app, rows);
                const nRows1 = text1.split(/\n/).length;
                console.log('nRows1', nRows1);
                yield sleep(sleepTime);
                const text2 = yield getTextContent(this.app, rows);
                const nRows2 = text2.split(/\n/).length;
                console.log('nRows2', nRows2);
                assert.ok(nRows2 > nRows1, `${nRows2} is not > ${nRows1}`);
                yield sleep(sleepTime);
                const text3 = yield getTextContent(this.app, rows);
                const nRows3 = text3.split(/\n/).length;
                console.log('nRows3', nRows3);
                assert.ok(nRows3 > nRows2, `${nRows3} is not > ${nRows2}`);
                yield this.app.client.click(rows);
                yield this.app.client.keys(Keys.ctrlC);
                yield sleep(sleepTime);
                const text4 = yield getTextContent(this.app, rows);
                const nRows4 = text4.split(/\n/).length;
                console.log('nRows4', nRows4);
                yield sleep(sleepTime);
                const text5 = yield getTextContent(this.app, rows);
                const nRows5 = text5.split(/\n/).length;
                console.log('nRows5', nRows5);
                assert.strictEqual(nRows5, nRows4);
            }
            catch (err) {
                yield Common.oops(this, true)(err);
            }
        }));
        deleteNS(this, ns);
    });
});
//# sourceMappingURL=logs-dash-f.js.map