/*
 * Copyright 2018 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import Debug from 'debug';
import { inBrowser, assertHasProxy, assertLocalAccess, setEvaluatorImpl } from '@kui-shell/core';
import { proxyServer } from '@kui-shell/client/config.d/proxy.json';
import { isDisabled } from './lib/config';
const debug = Debug('plugins/proxy-support/preload');
/**
 * This is the capabilities registraion
 *
 */
export const registerCapability = () => __awaiter(void 0, void 0, void 0, function* () {
    if (inBrowser()) {
        debug('config', proxyServer);
        if (!isDisabled(proxyServer)) {
            // notify the Capabilities manager that we have extended the
            // capabilities of Kui
            assertHasProxy();
            assertLocalAccess();
        }
    }
});
/**
 * This is the module
 *
 */
export default () => __awaiter(void 0, void 0, void 0, function* () {
    if (inBrowser()) {
        debug('config', proxyServer);
        if (!isDisabled(proxyServer)) {
            const ProxyEvaluator = (yield import('./lib/proxy-executor')).default;
            debug('attempting to establish our proxy executor');
            setEvaluatorImpl(new ProxyEvaluator());
        }
    }
});
//# sourceMappingURL=preload.js.map