"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
class CommandModelImpl {
    constructor() {
        this._root = this.newTree();
        this._disambiguator = {};
        this._catchalls = [];
    }
    get root() {
        return this._root;
    }
    get disambiguator() {
        return this._disambiguator;
    }
    get catchalls() {
        return this._catchalls;
    }
    read(argv, execOptions, tryCatchalls = true) {
        return __awaiter(this, void 0, void 0, function* () {
            const { read: readImpl } = yield Promise.resolve().then(() => require('../core/command-tree'));
            return readImpl(this.root, argv, undefined, execOptions, tryCatchalls);
        });
    }
    forEachNode(fn) {
        const iter = (root) => {
            if (root) {
                fn(root);
                if (root.children) {
                    for (const cmd in root.children) {
                        iter(root.children[cmd]);
                    }
                }
            }
        };
        iter(this.root);
    }
    newTree() {
        return {
            $: undefined,
            key: '/',
            route: '/',
            children: {},
            parent: undefined
        };
    }
}
exports.CommandModelImpl = CommandModelImpl;
function isWindowWithModel(win) {
    return win && win._kuiCommandModel !== undefined;
}
let theCommandModel;
function getModelInternal() {
    return (typeof window !== 'undefined' && isWindowWithModel(window) && window._kuiCommandModel) || theCommandModel;
}
exports.getModelInternal = getModelInternal;
function getModel() {
    return getModelInternal();
}
exports.getModel = getModel;
function init() {
    theCommandModel = new CommandModelImpl();
    if (typeof window !== 'undefined') {
        ;
        window._kuiCommandModel = theCommandModel;
    }
}
exports.init = init;
function initIfNeeded() {
    if (!theCommandModel) {
        init();
    }
}
exports.initIfNeeded = initIfNeeded;
//# sourceMappingURL=tree.js.map