import { Abortable } from './job';
import { Entity } from '../../models/entity';
import { Row } from '../../webapp/models/table';
export interface Watcher {
    init: (pusher: WatchPusher) => void;
}
export interface Watchable {
    watch: Watcher & Abortable;
}
export interface WatchPusher {
    update: (response: Row) => void;
    offline: (rowKey: string) => void;
    done: () => void;
    allOffline: () => void;
    header: (response: Row) => void;
}
export declare function isWatchable(model: Entity & Partial<Watchable>): model is Entity & Watchable;
