"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.optionsToString = (options) => {
    let str = '';
    for (const key in options) {
        if (key !== '_' &&
            options[key] !== undefined &&
            key !== 'name' &&
            key !== 'theme' &&
            typeof options[key] !== 'object') {
            const dash = key.length === 1 ? '-' : '--';
            const prefix = options[key] === false ? 'no-' : '';
            const value = options[key] === true || options[key] === false ? '' : ` ${options[key]}`;
            if (!(dash === '-' && options[key] === false)) {
                str = `${str} ${dash}${prefix}${key}${value}`;
            }
        }
    }
    return str;
};
exports.hasUnknownOptions = (options, expected) => {
    const M = expected.reduce((M, key) => {
        M[key] = true;
        return M;
    }, {});
    for (const opt in options) {
        if (opt !== '_' && !M[opt]) {
            throw new Error(`Unexpected option ${opt}`);
        }
    }
};
function flatten(arrays) {
    return [].concat(...arrays);
}
exports.flatten = flatten;
//# sourceMappingURL=utility.js.map